// priority: 5
let $饰品 = Java.loadClass("top.theillusivec4.curios.api.CuriosApi");
let $Either = Java.loadClass("com.mojang.datafixers.util.Either");

ItemEvents.tooltip((e) => {
  let p = Client.player;
  let 简单提示 = (event, itemIds, translationKey) => {
    for (let itemId of itemIds) {
      event.add(itemId, Component.translate(translationKey));
    }
  };

  if (global.自定义盔甲套装) {
    global.自定义盔甲套装.forEach(单个套装 => {

      if (!单个套装.TIP信息 || 单个套装.TIP信息.length === 0) return;

      let 部件和饰品列表 = [];
      if (单个套装.部件) {
        部件和饰品列表 = 部件和饰品列表.concat(Object.values(单个套装.部件));
      }
      if (单个套装.饰品) {
        单个套装.饰品.forEach(饰品项 => {
          if (typeof 饰品项 === "string") {
            部件和饰品列表.push(饰品项);
          } else if (typeof 饰品项 === "object" && 饰品项 !== null && 饰品项.id) {
            部件和饰品列表.push(饰品项.id);
          }
        });
      }

      if (部件和饰品列表.length === 0) return;

      let 按键 = 单个套装.按键条件 || "shift";
      let 按键名 = 单个套装.按键显示名称 || "Shift";

      let 检查按键是否按下 = () => {
        if (按键 === "shift") return e.shift;
        if (按键 === "ctrl") return e.ctrl;
        if (按键 === "alt") return e.alt;
        return false;
      };

      for (let 单个物品ID of 部件和饰品列表) {
        if (!单个物品ID || 单个物品ID === "") continue;

        e.addAdvanced(单个物品ID, (物品, 高级, 提示) => {
          if (检查按键是否按下()) {
            提示.add(1, Component.translate("kubejs.tooltip.set_bonus.title"));
            let 当前行号 = 2;
            for (let 单行提示 of 单个套装.TIP信息) {
              提示.add(当前行号, Text.of(单行提示));
              当前行号++;
            }

            if (单个套装.饰品 && Array.isArray(单个套装.饰品)) {
              单个套装.饰品.forEach(饰品项 => {
                if (typeof 饰品项 === "object" && 饰品项.id === 物品.id && 饰品项.前置饰品) {
                  提示.add(当前行号++, Text.of("§b前置饰品:")); 
                  let 前置列表 = Array.isArray(饰品项.前置饰品) ? 饰品项.前置饰品 : [饰品项.前置饰品];
                  前置列表.forEach(前置ID => {
                    let 前置物品 = Item.of(前置ID);
                    提示.add(当前行号++, Text.of(` §c- ${前置物品.displayName.string}`));
                  });
                }
              });
            }
          } else {
            提示.add(1, Component.translate("kubejs.tooltip.set_bonus.prompt", Text.aqua(`[${按键名}]`)));
          }
        });
      }
    });
  }

  简单提示(e, global.实验性玩法物品表, "kubejs.tooltip.generic.experimental");

  let 商店购买物品表 = [
    "waystones:waystone",
    "waystones:mossy_waystone",
    "waystones:sandy_waystone",
    "waystones:sharestone",
    "waystones:bound_scroll"];
  简单提示(e, 商店购买物品表, "kubejs.tooltip.generic.shop_buyable");

  let 强加载物品提示列表 = ["minecraft:beacon"];
  简单提示(e, 强加载物品提示列表, "kubejs.tooltip.generic.chunk_loader");

  e.addAdvanced(global.冰豆腐砖.物品ID, (物品, 高级, 提示) => {
    let 半径 = global.冰豆腐砖.伤害半径;
    let 伤害倍率百分比 = (global.冰豆腐砖.伤害倍率 * 100).toFixed(0);
    提示.add(1, Component.translate("kubejs.tooltip.ice_tofu.damage_desc", `§b${伤害倍率百分比}%`));
    提示.add(2, Component.translate("kubejs.tooltip.ice_tofu.radius_desc", `§a${半径}`));
    提示.add(3, Component.translate("kubejs.tooltip.ice_tofu.ignores_armor"));
  });

  e.addAdvanced(global.心之钢配置.饰品ID, (物品, 高级, 提示) => {
    let 基础生命单位 = global.心之钢配置.每多少生命值算一次加成;
    let 基础伤害加成 = global.心之钢配置.每点生命增加伤害百分比 * 基础生命单位 * 100;
    let nbt = 物品.getOrCreateTag();
    let 当前层数 = nbt.getInt(global.心之钢层数NBT) || 0;
    let 总生命加成 = global.心之钢配置.基础生命加成 + (Math.floor(当前层数 / global.心之钢配置.每几层加一次生命) * global.心之钢配置.每次增加多少生命);
    let 伤害加成百分比 = nbt.getDouble(global.心之钢伤害加成值NBT) || 0.0;
    提示.add(1, Component.translate("kubejs.tooltip.heart_of_steel.scaling", Text.red(基础生命单位 + " HP"), Text.gold("+" + 基础伤害加成.toFixed(1) + "%")));
    提示.add(2, Component.translate("kubejs.tooltip.heart_of_steel.stacks").append(Text.aqua(当前层数)));
    提示.add(3, Component.translate("kubejs.tooltip.heart_of_steel.health_bonus").append(Text.red("+" + 总生命加成.toFixed(1) + " HP")));
    提示.add(4, Component.translate("kubejs.tooltip.heart_of_steel.current_damage_bonus").append(Text.gold("+" + (伤害加成百分比 * 100).toFixed(1) + "%")));
    提示.add(5, Component.translate("kubejs.tooltip.heart_of_steel.healing_bonus").append(Text.green("x" + global.心之钢配置.治疗加成倍率.toFixed(1))));
  });

  e.addAdvanced(global.失乐园配置.饰品ID, (物品, 高级, 提示) => {
    let 最小饱食度 = global.失乐园配置.最小有效饱食度;
    let 每层加成文本 = (global.失乐园配置.每层伤害加成 * 100).toFixed(1);
    let NBT数据 = 物品.getOrCreateTag();
    let 食物层数 = NBT数据.getInt(global.失乐园配置.NBT层数) || 0;
    let 当前效果百分比 = (-global.失乐园配置.基础伤害惩罚 + 食物层数 * global.失乐园配置.每层伤害加成) * 100;
    let 效果文本;

    if (当前效果百分比 < -0.01) {
      效果文本 = Text.of(`§c${当前效果百分比.toFixed(1)}%`);
    } else {
      效果文本 = Text.of(`§a+${当前效果百分比.toFixed(1)}%`);
    }
    提示.add(1, Component.translate("kubejs.tooltip.paradise_lost.growth", `§e${最小饱食度}`, `§a+${每层加成文本}%`));
    提示.add(2, Component.translate("kubejs.tooltip.paradise_lost.valid_foods").append(Text.aqua(食物层数)));
    提示.add(3, Component.translate("kubejs.tooltip.paradise_lost.damage_bonus").append(效果文本));
  });
});

/*/
NativeEvents.onEvent(Java.loadClass("net.minecraftforge.client.event.RenderTooltipEvent$GatherComponents"), e => {
    let item = e.getItemStack();
    let nbt匹配 = false;

    if (item.getId() == "enigmaticlegacy:enigmatic_eye") {
        let nbt = item.getNbt();
        if (nbt != null &&
            nbt.getInt("ActivationAnimation") == -1 &&
            nbt.getByte("IsDormant") == 0) {
            nbt匹配 = true;
        }
    }

    if (nbt匹配) {
        let tip = e.getTooltipElements();
        tip.clear();
        tip.add($Either.left(Text.of("§4莫测之眼")));
        tip.add($Either.left(Text.of("§e栏位：§6护符")));
        tip.add($Either.left(Text.of("")));
        tip.add($Either.left(Text.of("§d现在你引起了祂的注意。")));
        tip.add($Either.left(Text.of("§d没人知道是谁在使用这个眼睛来观察你和你身处的世界，")));
        tip.add($Either.left(Text.of("§d但可以确定的是似乎其并没有表现出与你建立联系的意图。")));
        tip.add($Either.left(Text.of("§d祂是出于没有能力的缘故还是仅仅不想与你建立")));
        tip.add($Either.left(Text.of("§d非精神的联系？这个问题依旧有待解答。")));
        tip.add($Either.left(Text.of("")));
        tip.add($Either.left(Text.of("§d显示装备迷人徽章的玩家的真名。")));
        tip.add($Either.left(Text.of("")));
        tip.add($Either.left(Text.of("§e佩戴护符时：")));
        tip.add($Either.left(Text.of("§9+1 护符栏位")));
        tip.add($Either.left(Text.of("§9+0.5 方块范围")));
    }
});/*/
